
using WPFGallery.Navigation;
using WPFGallery.Views;
using WPFGallery.Models;

namespace WPFGallery.ViewModels
{
    public partial class MediaPageViewModel : ObservableObject
    {
        [ObservableProperty]
        private string _pageTitle = "Media Controls";

        [ObservableProperty]
        private string _pageDescription = "Controls for media presentation";
 
        [ObservableProperty]
        private ICollection<ControlInfoDataItem> _navigationCards = ControlsInfoDataSource.Instance.GetControlsInfo("Media");

        private readonly INavigationService _navigationService;

        public MediaPageViewModel(INavigationService navigationService)
        {
            _navigationService = navigationService;
        }

        [RelayCommand]
        public void Navigate(object pageType){
            if (pageType is Type page)
            {
                _navigationService.NavigateTo(page);
            }
        }

        
    }
}
